# Homepage Troubleshooting Guide

## Issue: Homepage appears "destroyed" or content is missing

Based on the screenshot provided, the homepage is showing:
- ✅ Hero slider (first slide visible)
- ✅ About section (visible)
- ❌ Statistics section (not visible)
- ❌ Features section (not visible)
- ❌ Blog posts section (not visible)
- ❌ Recent studies section (not visible)
- ❌ CTA section (not visible)

---

## Possible Causes & Solutions

### 1. **Browser Cache Issue** (Most Likely)
**Symptoms:** Old CSS/JS files are cached, new code isn't loading

**Solution:**
```
1. Open your browser
2. Press Ctrl+Shift+Delete (Windows) or Cmd+Shift+Delete (Mac)
3. Clear "Cached images and files"
4. Or do a hard refresh: Ctrl+Shift+R (Windows) or Cmd+Shift+R (Mac)
```

### 2. **JavaScript Error**
**Symptoms:** Page stops rendering after a certain point

**Solution:**
```
1. Press F12 to open Developer Tools
2. Go to "Console" tab
3. Look for red error messages
4. Share the error message for debugging
```

### 3. **CDN Libraries Not Loading**
**Symptoms:** Swiper, AOS, or LazyLoad not working

**Solution:**
```
1. Press F12 to open Developer Tools
2. Go to "Network" tab
3. Refresh the page
4. Look for failed requests (red text)
5. Check if these are loading:
   - swiper-bundle.min.css
   - swiper-bundle.min.js
   - aos.css
   - aos.js
   - lazyload.min.js
```

### 4. **PHP Error**
**Symptoms:** Page stops rendering mid-way

**Solution:**
```
1. Check if error_reporting is enabled in index.php (it is)
2. Look for PHP error messages on the page
3. Check Apache error logs: xampp/apache/logs/error.log
```

### 5. **Database Connection Issue**
**Symptoms:** Statistics show 0, no blog posts or studies

**Solution:**
```
1. Check if database is running in XAMPP
2. Verify database connection in config/database.php
3. Check if tables have data
```

---

## Quick Diagnostic Steps

### Step 1: Test Library Loading
Visit: `http://localhost/obgyn-research-platform/test-phase9.html`

This will show which libraries are loading:
- jQuery
- Bootstrap
- Swiper
- AOS
- LazyLoad

### Step 2: Check Browser Console
1. Open homepage
2. Press F12
3. Look for errors in Console tab
4. Common errors:
   - "Swiper is not defined" → Swiper not loading
   - "AOS is not defined" → AOS not loading
   - "Uncaught SyntaxError" → JavaScript syntax error

### Step 3: Check Network Tab
1. Press F12
2. Go to Network tab
3. Refresh page
4. Look for:
   - Red/failed requests
   - 404 errors
   - Slow loading resources

### Step 4: Inspect Element
1. Right-click on the page after "About" section
2. Select "Inspect" or "Inspect Element"
3. Look for the Statistics section in the HTML
4. Check if it has `display: none` or `visibility: hidden`

---

## Emergency Backup Solution

If the homepage is completely broken, you can:

### Option 1: Restore from Backup
If you have a backup of the working homepage, restore it.

### Option 2: Use Simple Homepage
I can create a simplified version without Swiper/AOS that will definitely work.

### Option 3: Debug Mode
Add this to the top of index.php after `<?php`:
```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
```

---

## What to Check Right Now

1. **Clear browser cache** (Ctrl+Shift+R)
2. **Check browser console** (F12 → Console tab)
3. **Check network requests** (F12 → Network tab)
4. **Scroll down the page** - content might be there but not visible
5. **Try different browser** - test in Chrome, Firefox, or Edge

---

## Expected Behavior

The homepage should:
1. Show hero slider with 5 slides auto-playing every 5 seconds
2. Show about section with 6 highlight cards
3. Show statistics with animated counters
4. Show 6 feature cards
5. Show 3 latest blog posts
6. Show 6 recent studies
7. Show CTA section (if not logged in)
8. Have smooth scroll animations (AOS)
9. Have sticky header on scroll
10. Have scroll-to-top button appear after scrolling

---

## Files to Verify

Make sure these files exist and are not corrupted:
- ✅ index.php
- ✅ templates/header.php
- ✅ templates/footer.php
- ✅ assets/js/main.js
- ✅ assets/css/style.css

---

## Next Steps

Please provide:
1. Screenshot of browser console (F12 → Console tab)
2. Screenshot of network tab showing failed requests (if any)
3. Any error messages you see on the page
4. Which browser you're using

This will help me identify the exact issue and provide a targeted fix.
